<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Allocations extends Model 
{

    protected $table = 'allocations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('time', 'task', 'priority', 'project_id', 'created_by', 'updated_by');

    public function getProject()
    {
        return $this->hasOne('Projects', 'project_id');
    }

    public function getUser()
    {
        return $this->hasOne('User', 'user_id');
    }

}